<?php

global $reviewsite_rating;

class ReviewSiteRating extends ReviewSiteMetaBox
{

	public $table		= "your_rating";
	public $structure;
	public $ratings;
						  
	/* init */
	function init()
	{
		$this->structure	= "`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,".
						  	  "`name` VARCHAR( 255 ) NOT NULL ,".
						  	  "`rating` TINYINT NOT NULL ,".
						  	  "`post_id` INT NOT NULL";
	
		if($this->checkTable($this->table) == 'false') :
			$this->createTable($this->table,$this->structure);
		else :
		endif;;
	}
	
	/* get all */
	function getAll($postid)
	{
		global $wpdb;
		
		$query	= "SELECT * FROM `".$wpdb->prefix.$this->table."`".
				  "WHERE post_id = '".$postid."' ".
				  "ORDER BY rating DESC";
				  
		$this->ratings	= $wpdb->get_results($query,ARRAY_A);
	}
	
	// post
	function post($postid)
	{
		$this->save($postid,$_POST['rating']['add']);
		$this->delete($postid,$_POST['review']['delete']);
	}
	
	//save
	function save($postid,$data)
	{
		global $wpdb;
		
		if(sizeof($data) > 0) :
			$insert_data	= array();
			foreach($data as $the_data) :
				$insert_data[]	= "('','".addslashes($the_data['title'])."','".$the_data['rating']."','".$postid."')";
			endforeach;
			
			$insert_string	= implode(',',$insert_data);
			
			$query		= "INSERT INTO `".$wpdb->prefix.$this->table."`".
						  "VALUES ".$insert_string.";";
						  
			$wpdb->query($query);
		endif;
	}
	
	//delete
	function delete($postid,$data)
	{
		global $wpdb;
		
		if(sizeof($data) > 0) :

			$delete_data	= array();
			foreach($data as $the_data => $value) :
				$delete_data[]	= $value;
			endforeach;
			
			$delete_string	= implode(',',$delete_data);
			
			$query		= "DELETE FROM `".$wpdb->prefix.$this->table."` WHERE id IN (".$delete_string."); ";
			$wpdb->query($query);
		endif;
	}
	
	// create table
	function table()
	{
		?>
        <table id="review-your-rating" border="1" width="90%" class="widefat">
        	<thead>
            <tr>
            	<th width="5%">No</th>
                <th>Title</th>
                <th width="10%">Rating</th>
                <th width="5%">Delete</th>
            </tr>
            </thead>
            <tbody>
        <?php
		$i	= 1;
		foreach($this->ratings as $rating) :
			?>
            <tr>
            	<td style="text-align:center;"><?php echo $i; ?></td>
                <td><?php echo $rating['name']; ?></td>
                <td style="text-align:center;"><?php echo $rating['rating']; ?></td>
                <td style="text-align:center;"><input type="checkbox" name="review[delete][<?php echo $i; ?>]" value="<?php echo $rating['id']; ?>" /></td>
            </tr>
            <?php
			$i++;
		endforeach;
		?>
        	</tbody>
	    </table>
        <?php
	}
	
	function front_table()
	{
		if(sizeof($this->ratings) > 0) :
		?>
        <table id="post-your-rating" border="1" cellpadding="5" cellspacing="2" border="#B6B6B6">
        	<thead>
            <tr>
                <th colspan="2">Final Conclusion</th>
            </tr>
            </thead>
            <tbody>
        <?php
		$i	= 1;
		foreach($this->ratings as $rating) :
			?>
            <tr>
                <td class="name" width="40%"><?php echo $rating['name']; ?></td>
                <td class="star" style="text-align:left;">
                <?php for($i = 1;$i <= $rating['rating']; $i++) : ?>
                <img src="<?php bloginfo('template_url'); ?>/images/icon-star-mid.png" alt="Rating" />
                <?php endfor; ?>
                </td>
            </tr>
            <?php
			$i++;
		endforeach;
		?>
        	</tbody>
	    </table>
        <?php
		endif;
	}
	
	// create form
	function form ()
	{
		?>
        <div class="reviewSite-metabox">
        <br /><br />
        <strong>Add Your Rating</strong>
        <br /><br />

        <label for="reviewsite_profile_photo">Name</label>
        <input type="text" id="rating-title" value="" size="40" />
        <select id="rating-choice">
        	<option value="5" selected="selected">5 (Best)</option>
            <option value="4">4 (Very Good)</option>
            <option value="3">3 (Good)</option>
            <option value="2">2 (Not Good Enough)</option>
            <option value="1">1 (Bad)</option>
        </select>
        <input type="button" id="rating-add" value="Add" />
        <br /><br />
        
        <script type="text/javascript" language="javascript1.2">
			jQuery('#rating-add').click(function(){
				var rating_title	= jQuery('#rating-title').val();
				var rating_number	= jQuery('#rating-choice').val();
				var rating_count	= jQuery('#review-your-rating tbody tr').size();
				var tr_text			= "";
				var td_text			= "";
				var td_row			= "";

				td_row		= parseInt(rating_count) + 1;
					
				td_text		= td_text + "<td style='text-align:center;'>" + td_row + "</td>";
				td_text		= td_text + "<td>" + rating_title + "</td>";
				td_text		= td_text + "<td style='text-align:center;'>" + rating_number + "</td>";
				td_text		= td_text + "<td style='text-align:center;'>";
				//td_text			= td_text + "<input type='checkbox' name='rating[delete][" + td_row + "]' value='" + td_row + "' /></td>";
				//td_text			= td_text + "<a href='#' rel='rating-" + td_row + "' class='delete-review'>delete</a></td>";
				td_text		= td_text + "<a href='#' rel='rating-" + td_row + "' class='delete-review' onClick='deleteRow(" + td_row + ");return false'>delete</a></td>";
					
				td_text		= td_text + "<input type='hidden' name='rating[add][" + td_row + "][title]' value='" + rating_title + "' />";
				td_text		= td_text + "<input type='hidden' name='rating[add][" + td_row + "][rating]' value='" + rating_number + "' />";
				tr_text		= "<tr id='rating-" + td_row + "'> " + td_text + "</tr>";
					
				jQuery('#review-your-rating tbody:last').append(tr_text);
				return false;
			});
			
			function deleteRow(id)
			{
				var removeID	= "#rating-" + id;
				jQuery(removeID).remove();

				return false;
			}
			
		</script>
        
        </div>
        <?php
	}
	
	function postrating()
	{
		$values	= 0;

		if(sizeof($this->ratings) > 0) :

			foreach($this->ratings as $rating) :
				$values	+= $rating['rating'];
				//echo($rating['rating']);
			endforeach;
		
			$avrg	= round($values / count($this->ratings));
			
			for($i = 1;$i <= $avrg ; $i++) :
				?><img src="<?php bloginfo('template_url'); ?>/images/icon-star.png" alt="" /><?php
			endfor;
			
		endif;
	}
}

$reviewsite_rating	= new ReviewSiteRating;
$reviewsite_rating->init();

function reviewSiteShowRating($post_id)
{
	global $reviewsite_rating;
	
	$reviewsite_rating->getAll($post_id);
	$reviewsite_rating->front_table();
}

function reviewSitePostRating($post_id)
{
	global $reviewsite_rating;
	
	//$reviewsite_rating->getAll($post_id);
	//$reviewsite_rating->postrating();
	$post_rating	= reviewSiteCustomPost("reviewsite_post_rating"	,$post_id);
	
	if(!empty($post_rating)) :
		for($i = 1;$i <= $post_rating;$i++):
			?><img src="<?php bloginfo('template_url'); ?>/images/icon-star.png" alt="" /><?php
		endfor;
	endif;
}